# AI 海龟汤项目教程

## 教程地址

完整项目文字+视频教程：[点击查看](https://www.codefather.cn/course/1898973113527894017?contentType=text&current=1&tabKey=info)

## 项目介绍

几个小时就能学完的 AI 原生项目，通过做一个 AI 海龟汤游戏网站，带大家快速实战 AI 项目的开发流程，紧跟时代的前沿。

海龟汤是一个老少咸宜的小游戏，分为汤面和汤底，主持人讲一个故事（汤面），由玩家通过提问的方式来不断地揭露还原故事的真相（汤底）。

可以让 AI 代替传统海龟汤的主持人，玩家只需要向 AI 对话，就能够自己进行海龟汤的游戏。

![img](https://pic.yupi.icu/yuyi/511KVxpdc4Gydtcj.webp)

本项目的核心功能点：

- 和 AI 主持人对话 P0
- 查看往期的对话记录 P1

### 你将收获

1. 学习标准的企业项目开发流程：需求分析 => 方案设计 => 后端开发 + 前端开发 => 测试 => 部署上线（可选）
2. 学习如何快速初始化前后端项目
3. 学习在程序中接入 AI 大模型
4. 学习如何封装自己的 AI 工具类
5. 学习如何优化 Prompt
6. 学习如何维护对话上下文并传递给 AI
7. 学习如何利用 AI 补全代码
8. 学习如何纯利用 AI 开发前端网站

## 技术选型

### 前端

- Vue 3：适合快速开发单页面应用
- Ant Design Vue：主流组件库，兼容 PC 端和移动端响应式
- Vue Router：前端路由组件
- Axios：主流的请求库

### 后端

- Java + Spring Boot 框架
- MySQL 数据库
- MyBatis + MyBatis Plus 框架
- Hutool 工具类
- Swagger + Knife4j 接口文档组合
- AI 大模型接入

## 业务流程

1）玩家进入页面，点击【开始游戏】，进入聊天室页面

2）进入聊天室页面时，AI 会立刻给出一个招呼语（给出故事汤面）

3）接下来，用户可以和 AI 主持人进行对话

4）用户可以主动结束，也可以由 AI 主动结束游戏

5）用户可以随时查看往期的对话记录

如图：

![img](https://pic.yupi.icu/yuyi/F2NmpSDxwhEDKxXH.webp)

## 部分教程截图

1）快速初始化后端项目、运行接口文档来调试接口

![img](https://pic.yupi.icu/yuyi/GzKjYDxDOKlCXJit.webp)

2）接入 AI 并调试优化 Prompt 提示词

![img](https://pic.yupi.icu/yuyi/1KlC2eIOKtHs45g5.webp)

---

加入编程导航，获取 10+ 套原创企业级实战项目，可以直接写进简历：

https://yuyuanweb.feishu.cn/wiki/VC1qwmX9diCBK3kidyec74vFnde